/*
 * Decompiled with CFR 0.152.
 */
package i18nupdatemod.core;

import i18nupdatemod.util.AssetUtil;
import i18nupdatemod.util.DigestUtil;
import i18nupdatemod.util.FileUtil;
import i18nupdatemod.util.Log;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.security.NoSuchAlgorithmException;
import java.util.concurrent.TimeUnit;

public class ResourcePack {
    private static final long UPDATE_TIME_GAP = TimeUnit.DAYS.toMillis(1L);
    private final String filename;
    private final Path filePath;
    private final Path tmpFilePath;
    private final boolean saveToGame;
    private String remoteMd5;

    public ResourcePack(String filename, boolean saveToGame) {
        this.saveToGame = saveToGame;
        this.filename = filename;
        this.filePath = FileUtil.getResourcePackPath(filename);
        this.tmpFilePath = FileUtil.getTemporaryPath(filename);
        try {
            FileUtil.syncTmpFile(this.filePath, this.tmpFilePath, saveToGame);
        }
        catch (Exception e) {
            Log.warning(String.format("Error while sync temp file %s <-> %s: %s", this.filePath, this.tmpFilePath, e));
        }
    }

    public void checkUpdate(String fileUrl, String md5Url) throws IOException, URISyntaxException, NoSuchAlgorithmException {
        if (this.isUpToDate(md5Url)) {
            Log.debug("Already up to date.");
            return;
        }
        this.downloadFull(fileUrl, md5Url);
    }

    private boolean isUpToDate(String md5Url) throws IOException, URISyntaxException, NoSuchAlgorithmException {
        if (!Files.exists(this.tmpFilePath, new LinkOption[0])) {
            Log.debug("Local file %s not exist.", this.tmpFilePath);
            return false;
        }
        if (Files.getLastModifiedTime(this.tmpFilePath, new LinkOption[0]).to(TimeUnit.MILLISECONDS) > System.currentTimeMillis() - UPDATE_TIME_GAP) {
            Log.debug("Local file %s has been updated recently.", this.tmpFilePath);
            return true;
        }
        return this.checkMd5(this.tmpFilePath, md5Url);
    }

    private boolean checkMd5(Path localFile, String md5Url) throws IOException, URISyntaxException, NoSuchAlgorithmException {
        String localMd5 = DigestUtil.md5Hex(localFile);
        if (this.remoteMd5 == null) {
            this.remoteMd5 = AssetUtil.getString(md5Url);
        }
        Log.debug("%s md5: %s, remote md5: %s", localFile, localMd5, this.remoteMd5);
        return localMd5.equalsIgnoreCase(this.remoteMd5);
    }

    private void downloadFull(String fileUrl, String md5Url) throws IOException {
        try {
            Path downloadTmp = FileUtil.getTemporaryPath(this.filename + ".tmp");
            AssetUtil.download(fileUrl, downloadTmp);
            if (!this.checkMd5(downloadTmp, md5Url)) {
                throw new IOException("Download MD5 not match");
            }
            Files.move(downloadTmp, this.tmpFilePath, StandardCopyOption.REPLACE_EXISTING);
            Log.debug(String.format("Updates temp file: %s", this.tmpFilePath));
        }
        catch (Exception e) {
            Log.warning("Error while downloading: %s", e);
        }
        if (!Files.exists(this.tmpFilePath, new LinkOption[0])) {
            throw new FileNotFoundException("Tmp file not found.");
        }
        FileUtil.syncTmpFile(this.filePath, this.tmpFilePath, this.saveToGame);
    }

    public Path getTmpFilePath() {
        return this.tmpFilePath;
    }

    public String getFilename() {
        return this.filename;
    }
}

