/*
 * Decompiled with CFR 0.152.
 */
package i18nupdatemod.util;

import java.lang.reflect.Field;
import java.lang.reflect.Method;

public class Reflection {
    private final Class<?> clazz;
    private Object instance;

    public Reflection(Class<?> clazz) {
        this.clazz = clazz;
    }

    public Reflection(Object instance) {
        if (instance == null) {
            throw new IllegalArgumentException("Instance cannot be null");
        }
        this.clazz = instance.getClass();
        this.instance = instance;
    }

    public static Reflection clazz(String className) throws ClassNotFoundException {
        return new Reflection(Class.forName(className));
    }

    public static Reflection clazz(Class<?> clazz) {
        return new Reflection(clazz);
    }

    public static Reflection clazz(Object instance) {
        return new Reflection(instance);
    }

    private Reflection getField(String field) throws Exception {
        Field field0 = this.clazz.getDeclaredField(field);
        field0.setAccessible(true);
        return new Reflection(field0.get(this.instance));
    }

    private Reflection invokeMethod(String method) throws Exception {
        Method method1 = this.clazz.getDeclaredMethod(method, new Class[0]);
        method1.setAccessible(true);
        return new Reflection(method1.invoke(this.instance, new Object[0]));
    }

    public Reflection get(String fieldOrMethod) throws Exception {
        if (fieldOrMethod.endsWith(")")) {
            return this.invokeMethod(fieldOrMethod.replace("()", ""));
        }
        return this.getField(fieldOrMethod);
    }

    public Object get() {
        return this.instance;
    }
}

